<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://portail.hainaut.be/institution/direction-generale-des-systemes-dinformation
 * @since             1.0.0
 * @package           Dgsi_Infolettre_Images_Sizes
 *
 * @wordpress-plugin
 * Plugin Name:       DGSI Infolettre Images Sizes
 * Plugin URI:        https://dgsi-ads.hainaut.be/dgsi-assets/manage
 * Description:       DGSI Infolettre Images Sizes adds 3 image sizes used to create newsletters on the Newsletter Portal of the Province de Hainaut.
 * Version:           3.0.0
 * Author:            Julien Delneufcourt (Direction Générale des Systèmes d'Information)
 * Author URI:        https://portail.hainaut.be/institution/direction-generale-des-systemes-dinformation
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       dgsi-infolettre-images-sizes
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'DGSI_INFOLETTRE_IMAGES_SIZES_VERSION', '3.0.0' );

define( 'DIIS_UPDATE_BASE_URL', 'https://dgsi-ads.hainaut.be/dgsi-assets/update/');
define( 'DGSI_INFOLETTRE_IMAGES_SIZES_SLUG', 'dgsi-infolettre-images-sizes');

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-dgsi-infolettre-images-sizes-activator.php
 */
function activate_dgsi_infolettre_images_sizes() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-dgsi-infolettre-images-sizes-activator.php';
	Dgsi_Infolettre_Images_Sizes_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-dgsi-infolettre-images-sizes-deactivator.php
 */
function deactivate_dgsi_infolettre_images_sizes() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-dgsi-infolettre-images-sizes-deactivator.php';
	Dgsi_Infolettre_Images_Sizes_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_dgsi_infolettre_images_sizes' );
register_deactivation_hook( __FILE__, 'deactivate_dgsi_infolettre_images_sizes' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-dgsi-infolettre-images-sizes.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_dgsi_infolettre_images_sizes() {

	$plugin = new Dgsi_Infolettre_Images_Sizes();
	$plugin->run();

}
run_dgsi_infolettre_images_sizes();
