<?php

/**
 * Fired during plugin deactivation
 *
 * @link       https://portail.hainaut.be/institution/direction-generale-des-systemes-dinformation
 * @since      1.0.0
 *
 * @package    Dgsi_Infolettre_Images_Sizes
 * @subpackage Dgsi_Infolettre_Images_Sizes/includes
 */

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    Dgsi_Infolettre_Images_Sizes
 * @subpackage Dgsi_Infolettre_Images_Sizes/includes
 * @author     Julien Delneufcourt (Direction Générale des Systèmes d'Information) <julien.delneufcourt@hainaut.be>
 */
class Dgsi_Infolettre_Images_Sizes_Deactivator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function deactivate() {
    
    // Delete site in plugin active installations on dgsi-ads.hainaut.be/dgsi-assets/manage
    $url = DIIS_UPDATE_BASE_URL . 'update-infos.php?a=deactivate&p=' . DGSI_INFOLETTRE_IMAGES_SIZES_SLUG . '&u=' . home_url();
    $curl = curl_init( $url );
    curl_setopt( $curl, CURLOPT_RETURNTRANSFER, true );
    $curl_response = curl_exec($curl);
    $err = curl_error($curl);
    curl_close($curl);

	}

}
