<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://portail.hainaut.be/institution/direction-generale-des-systemes-dinformation
 * @since      1.0.0
 *
 * @package    Dgsi_Infolettre_Images_Sizes
 * @subpackage Dgsi_Infolettre_Images_Sizes/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Dgsi_Infolettre_Images_Sizes
 * @subpackage Dgsi_Infolettre_Images_Sizes/includes
 * @author     Julien Delneufcourt (Direction Générale des Systèmes d'Information) <julien.delneufcourt@hainaut.be>
 */
class Dgsi_Infolettre_Images_Sizes_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'dgsi-infolettre-images-sizes',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
