<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       https://portail.hainaut.be/institution/direction-generale-des-systemes-dinformation
 * @since      1.0.0
 *
 * @package    Dgsi_Infolettre_Images_Sizes
 * @subpackage Dgsi_Infolettre_Images_Sizes/includes
 */

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    Dgsi_Infolettre_Images_Sizes
 * @subpackage Dgsi_Infolettre_Images_Sizes/includes
 * @author     Julien Delneufcourt (Direction Générale des Systèmes d'Information) <julien.delneufcourt@hainaut.be>
 */
class Dgsi_Infolettre_Images_Sizes {

	/**
	 * The loader that's responsible for maintaining and registering all hooks that power
	 * the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      Dgsi_Infolettre_Images_Sizes_Loader    $loader    Maintains and registers all hooks for the plugin.
	 */
	protected $loader;

	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $plugin_name    The string used to uniquely identify this plugin.
	 */
	protected $plugin_name;

	/**
	 * The current version of the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $version    The current version of the plugin.
	 */
	protected $version;

	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {
		if ( defined( 'DGSI_INFOLETTRE_IMAGES_SIZES_VERSION' ) ) {
			$this->version = DGSI_INFOLETTRE_IMAGES_SIZES_VERSION;
		} else {
			$this->version = '1.0.0';
		}
		$this->plugin_name = DGSI_INFOLETTRE_IMAGES_SIZES_SLUG;

		$this->load_dependencies();
		$this->set_locale();
		$this->define_admin_hooks();
		$this->define_public_hooks();

	}

	/**
	 * Load the required dependencies for this plugin.
	 *
	 * Include the following files that make up the plugin:
	 *
	 * - Dgsi_Infolettre_Images_Sizes_Loader. Orchestrates the hooks of the plugin.
	 * - Dgsi_Infolettre_Images_Sizes_i18n. Defines internationalization functionality.
	 * - Dgsi_Infolettre_Images_Sizes_Admin. Defines all hooks for the admin area.
	 * - Dgsi_Infolettre_Images_Sizes_Public. Defines all hooks for the public side of the site.
	 *
	 * Create an instance of the loader which will be used to register the hooks
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function load_dependencies() {

		/**
		 * The class responsible for orchestrating the actions and filters of the
		 * core plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-dgsi-infolettre-images-sizes-loader.php';

		/**
		 * The class responsible for defining internationalization functionality
		 * of the plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-dgsi-infolettre-images-sizes-i18n.php';

		/**
		 * The class responsible for defining all actions that occur in the admin area.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-dgsi-infolettre-images-sizes-admin.php';

		/**
		 * The class responsible for defining all actions that occur in the public-facing
		 * side of the site.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-dgsi-infolettre-images-sizes-public.php';

		$this->loader = new Dgsi_Infolettre_Images_Sizes_Loader();

	}

	/**
	 * Define the locale for this plugin for internationalization.
	 *
	 * Uses the Dgsi_Infolettre_Images_Sizes_i18n class in order to set the domain and to register the hook
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function set_locale() {

		$plugin_i18n = new Dgsi_Infolettre_Images_Sizes_i18n();

		$this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'load_plugin_textdomain' );

	}

	/**
	 * Register all of the hooks related to the admin area functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_admin_hooks() {

		$plugin_admin = new Dgsi_Infolettre_Images_Sizes_Admin( $this->get_plugin_name(), $this->get_version() );

		/*$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );*/
    
    // Add new image styles
    $this->loader->add_action( 'init', $plugin_admin, 'add_new_image_sizes' );
    // Upscale thumbnails smaller than image styles
    $this->loader->add_filter( 'image_resize_dimensions', $plugin_admin, 'thumbnail_upscale', 10, 6 );
    
    // Create the settings form
    $this->loader->add_action( 'admin_init', $plugin_admin, 'settings_init' );
    // Add settings page to the menu
    $this->loader->add_action( 'admin_menu', $plugin_admin, 'menu_page' );
    
    // Check for update
    $this->loader->add_filter( 'plugins_api', $plugin_admin, 'info', 20, 3 );
    $this->loader->add_filter( 'site_transient_update_plugins', $plugin_admin, 'update' );
    $this->loader->add_action( 'upgrader_process_complete', $plugin_admin, 'purge', 10, 2 );
    
    // Add links 'View Details' and 'Documentation' to plugin meta on plugins list page
    $this->loader->add_filter( 'plugin_row_meta',$plugin_admin, 'plugin_meta_links', 10, 2 );

	}

	/**
	 * Register all of the hooks related to the public-facing functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_public_hooks() {

		$plugin_public = new Dgsi_Infolettre_Images_Sizes_Public( $this->get_plugin_name(), $this->get_version() );

		/*$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_scripts' );*/

	}

	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    1.0.0
	 */
	public function run() {
		$this->loader->run();
	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 *
	 * @since     1.0.0
	 * @return    string    The name of the plugin.
	 */
	public function get_plugin_name() {
		return $this->plugin_name;
	}

	/**
	 * The reference to the class that orchestrates the hooks with the plugin.
	 *
	 * @since     1.0.0
	 * @return    Dgsi_Infolettre_Images_Sizes_Loader    Orchestrates the hooks of the plugin.
	 */
	public function get_loader() {
		return $this->loader;
	}

	/**
	 * Retrieve the version number of the plugin.
	 *
	 * @since     1.0.0
	 * @return    string    The version number of the plugin.
	 */
	public function get_version() {
		return $this->version;
	}

}
